' *************************************** Q METER ********************************
'
' On PCB CSE220601
'
$regfile = "m328pdef.dat"                              ' Chip description
$hwstack = 50                                          ' make sure stacks big enough
$swstack = 50
$framesize = 50
$crystal = 16000000                                    ' 16 MHz crystal on NANO



Ddrb = &B00_0000                                  ' 0-3 are CAP switches
Portb = &B00_1100

Ddrc = &B0000_0111
Portc = &B0000_0000

Ddrd = &B1111_0000
Portd = &B0000_0100

$baud = 38400

Cr Alias &H0D



Dim Input_voltage As Dword                        ' read Vin
Dim Output_voltage As Dword
Dim Q_value As Dword
Dim Frequency As Dword
Dim Vin As Dword
Dim Vout As Dword
Dim Display_output As Dword
Dim Remainder As Dword
Dim Half_vin As Dword
Dim Volts As Dword

Dim Vo_display As Dword
Dim Capacitance As Integer
Dim Display_cap As Integer                        ' add 40 pF


Dim Sample As Byte
Dim Step_value As Byte
Dim Encoder_value As Byte

Dim Encoder_switch As Bit
Dim Go_read As Bit
Dim Window As Bit
Dim Direction As Bit                              'rotary encoder direction
Dim Increase As Bit
Dim Decrease As Bit
Dim Cap_step As Bit
Dim Q_reading As Bit
Dim Over_voltage As Bit

Cap1 Alias Portb.1                                ' RY1
Cap2 Alias Portc.2                                ' RY2
Cap4 Alias Portc.0                                ' RY4
Cap8 Alias Portd.5                                ' RY6
Cap16 Alias Portc.1                               ' RY3
Cap32 Alias Portd.4                               ' RY5
Cap64 Alias Portd.6                               ' RY7
Cap128 Alias Portd.7                              ' RY8


Print "Q Meter Ver 2.0" ; Chr(cr);


$lib "glcdSSD1306-I2C.lib"
Config Graphlcd = Custom , Cols = 128 , Rows = 64 , Lcdname = "SSD1306"
Config Timer1 = Timer , Prescale = 1024
Setfont Font16x16
Config Adc = Single , Prescaler = Auto , Reference = Avcc       ' Use 5V ref

Config Int0 = Falling
Config Int1 = Falling
Config Scl = Portc.5                                   ' used i2c pins
Config Sda = Portc.4
I2cinit


Enable Int1
Enable Int0
Enable Timer1
Enable Interrupts


On Timer1 Tick
On Int1 Rotary_encoder
On Int0 Step_size

Splash_screen:
    Lcdat 1 , 1 , " Q Meter" , 2
    Lcdat 3 , 1 , "        " , 2
    Lcdat 5 , 1 , "Ver 3.0 " , 2
    Lcdat 7 , 1 , "Sep 2022" , 2

   Wait 1
   Cls
   Q_reading = 1
   Lcdat 7 , 1 , "C=40pF  "


Main:
   If Increase = 1 Then Gosub Higher_cap
   If Decrease = 1 Then Gosub Lower_cap
   If Cap_step = 0 Then Step_value = 1 Else Step_value = 10
   If Q_reading = 1 Then Gosub Calculate_q
   Waitms 100
   Goto Main

' ------------------------------------------------------------------------
' Higher cap increases capacitance

Higher_cap:
   Increase = 0
   Decrease = 0
   If Capacitance < 255 Then Capacitance = Capacitance + Step_value
   If Capacitance > 255 Then Capacitance = 255
   Display_cap = Capacitance + 40
   If Display_cap < 100 Then Lcdat 7 , 1 , "C=" ; Display_cap ; "pF "
   If Display_cap => 100 Then Lcdat 7 , 1 , "C=" ; Display_cap ; "pF"
   Print "C=" ; Capacitance ; " pF" ; Chr(cr);
   Gosub Switch_capacitors
   Return


' -----------------------------------------------------------------------------
' Lower cap decreases capacitance

Lower_cap:
   Decrease = 0
   Increase = 0
   If Capacitance > 0 Then Capacitance = Capacitance - Step_value
   If Capacitance < 0 Then Capacitance = 0
   Display_cap = Capacitance + 40
   If Display_cap < 100 Then Lcdat 7 , 1 , "C=" ; Display_cap ; "pF "
   If Display_cap => 100 Then Lcdat 7 , 1 , "C=" ; Display_cap ; "pF"
   Print "C=" ; Capacitance ; " pF" ; Chr(cr);
   Gosub Switch_capacitors
   Return


' -----------------------------------------------------------------------------
' Switch capacitors turns on the relay according to which bit
' is on or off in Capacitance.

Switch_capacitors:
   Cap1 = Capacitance.0
   Cap2 = Capacitance.1
   Cap4 = Capacitance.2
   Cap8 = Capacitance.3
   Cap16 = Capacitance.4
   Cap32 = Capacitance.5
   Cap64 = Capacitance.6
   Cap128 = Capacitance.7

   Return

All_off:
   Cap1 = 0
   Cap2 = 0
   Cap4 = 0
   Cap8 = 0
   Cap16 = 0
   Cap32 = 0
   Cap64 = 0
   Cap128 = 0
   Return

' ---------------------------------------------------------------------------
 ' ********************************* ROTARY ENCODER ************************************************
'
' Rotary encoder steps attenuation up or down. Om interrupt read
' Port B and testbi ts 0 and 3.

Rotary_encoder:

   Q_reading = 0
   Timer1 = 65535 - 15600                         ' start 1 second timer
   Direction = Not Pinb.3                         ' read direction
  ' Waitms 10
   Encoder_value = Pind.3
   Encoder_value = Encoder_value Or Pinb.0
   Print "EV=" ; Encoder_value ; " ";
   If Encoder_value = &B1001 Then Goto Re_exit
   If Direction = 0 Then Gosub Normal Else Gosub Reverse
   Waitms 10

 Re_exit:
   Return

Normal:
  ' Disable Int1
   If Encoder_value = 1 Then Increase = 1
   If Encoder_value = 0 Then Decrease = 1
   Return

Reverse:
  ' Disable Int1
   If Encoder_value = 0 Then Increase = 1
   If Encoder_value = 1 Then Decrease = 1
   Return

' ********************************************* TIMER 0 INTERRUPT **********************************
'
Tick:
   Q_reading = 1
   Return

' ************************** CALCULATE Q ********************************


Calculate_q:
   Go_read = 0
   Gosub Read_voltages
   Q_value = Output_voltage / Input_voltage
   If Pinb.2 = 0 Then Gosub High_q
   If Pinb.2 = 1 Then Gosub Low_q                 ' swich for LOW Q
   Lcdat 1 , 1 , "Inductor" , 2
   If Over_voltage = 1 Then Lcdat 3 , 1 , "TOO HIGH"
   If Over_voltage = 1 Then Goto Cq_10
   If Q_value < 100 Then Lcdat 3 , 1 , "Q = " ; Q_value ; "  "
   If Q_value => 100 Then Lcdat 3 , 1 , "Q = " ; Q_value ; " "
'   If Q_value < 5 Then Lcdat 3 , 1 , "Q < 5  "
Cq_10:
   Volts = Display_output / 100                   ' whole volts
   Remainder = Display_output Mod 100             ' fraction of volt
  ' If Display_output => 50 Then Lcdat 5 , 1 , "Vo=" ; Display_output ; " "
  ' If Display_output < 100 Then Lcdat 5 , 1 , "Vo=" ; Display_output ; "  "
  ' If Display_output < 1000 Then Lcdat 5 , 1 , "Vo=" ; Display_output ; " "
'   Lcdat 5 , 1 , "Vo=" ; Volts ; "." ; Remainder ; " "
   If Remainder < 10 Then Lcdat 5 , 1 , "Vo=" ; Volts ; "." ; Remainder ; "V "
   If Remainder => 10 Then Lcdat 5 , 1 , "Vo=" ; Volts ; "." ; Remainder ; "V"
   Print "Vi=" ; Input_voltage ; " Vo=" ; Output_voltage ; " Q=" ; Q_value ; Chr(cr);
   Return

 High_q:
   Q_value = Q_value * 225
   Q_value = Q_value / 100
   Return

 Low_q:
    Q_value = Q_value * 46
    Q_value = Q_value / 112
    Return


' ----------------------------------------------------------------------------

' Input Voltage is 10 times what is applied to tuned circuit
' due to 10:1 transformer.
' Measure each 4 times for average

Read_voltages:
   Input_voltage = 0
   For Sample = 1 To 4
   Vin = Getadc(7)
   Input_voltage = Input_voltage + Vin
   Waitms 10
   Next
   Input_voltage = Input_voltage / 18             ' transformer turns ratio
   ' and scaling
   Waitms 10

' Measure Output voltage

   Output_voltage = 0
   For Sample = 1 To 4
   Vout = Getadc(3)
   Output_voltage = Output_voltage + Vout
   Waitms 10
   Next
   Display_output = Output_voltage * 25
   Display_output = Display_output / 204

   If Display_output > 450 Then Set Over_voltage
   If Display_output <= 450 Then Reset Over_voltage
   Output_voltage = Output_voltage * 31
   Output_voltage = Output_voltage / 10           ' voltage divider

   Print "Vi=" ; Input_voltage ; " Vo=" ; Output_voltage ; " Q=" ; Q_value ; Chr(cr);

   Return


 ' ******************************** STEP SIZE ***********************************
'
' Toggle cap step

Step_size:
   Toggle Cap_step
   Return



$include "font16x16.font"